﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

//ConfigurationManager is a singleton class responsible for managing all configuration elements in Configuration.xml.
public class ConfigurationManager : MonoBehaviour
{
    //All our sub-configuration elements
    public CoreConfiguration Core { get; private set; }
    public GenerationConfiguration Generation { get; private set; }
    public TerrainConfiguration Terrain { get; private set; }
    public MinimapConfiguration Minimap { get; private set; }
    public PlayerConfiguration Player { get; private set; }
    public MissionsConfiguration Missions { get; private set; }
    public CarsConfiguration Cars { get; private set; }

    //Singleton
    private static ConfigurationManager _Instance;
    public static ConfigurationManager Instance
    {
        get
        {
            if (_Instance == null)
            {
                _Instance = FindObjectOfType<ConfigurationManager>();
            }

            return _Instance;
        }
    }

    public bool Initialize()
    {
        return ParseConfiguration();
    }

    private bool ParseConfiguration()
    {
        try
        {
            //Let's load our XML and create our sub configuration objects
            TextAsset xmlText = (TextAsset)Resources.Load("Configuration");
            XDocument configXML = XDocument.Parse(xmlText.text);

            Core = new CoreConfiguration();
            Generation = new GenerationConfiguration();
            Terrain = new TerrainConfiguration();
            Minimap = new MinimapConfiguration();
            Player = new PlayerConfiguration();
            Missions = new MissionsConfiguration();
            Cars = new CarsConfiguration();

            //Let's try to parse all of our sub configurations, passing in the corresponding parent elements
            if (Core.Parse(configXML.Root.Element("Core")))
            {
                if (Generation.Parse(configXML.Root.Element("Generation")))
                {
                    if (Terrain.Parse(configXML.Root.Element("Terrain")))
                    {
                        if (Minimap.Parse(configXML.Root.Element("Minimap")))
                        {
                            if (Player.Parse(configXML.Root.Element("Player")))
                            {
                                if (Missions.Parse(configXML.Root.Element("Missions")))
                                {
                                    if (Cars.Parse(configXML.Root.Element("Cars")))
                                    {
                                        return true;    //Parsed everything successfully!
                                    }

                                    else
                                    {
                                        Debug.LogError("ERROR: Failed to parse cars configuration. Perhaps the XML is malformed?");
                                    }
                                }

                                else
                                {
                                    Debug.LogError("ERROR: Failed to parse missions configuration. Perhaps the XML is malformed?");
                                }
                            }

                            else
                            {
                                Debug.LogError("ERROR: Failed to parse player configuration. Perhaps the XML is malformed?");
                            }
                        }

                        else
                        {
                            Debug.LogError("ERROR: Failed to parse minimap configuration. Perhaps the XML is malformed?");
                        }
                    }

                    else
                    {
                        Debug.LogError("ERROR: Failed to parse terrain configuration. Perhaps the XML is malformed?");
                    }
                }

                else
                {
                    Debug.LogError("ERROR: Failed to parse generation configuration. Perhaps the XML is malformed?");
                }
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse core configuration. Perhaps the XML is malformed?");
            }

            return false;   //We must have failed to parse one of the configurations
        }

        catch (Exception ex)
        {
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
